/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.admin.jmsspi;

import com.sun.messaging.jmq.admin.jmsspi.JMSAdminImpl;
import com.sun.messaging.jmq.admin.resources.AdminResources;
import com.sun.messaging.jmq.admin.util.Globals;
import com.sun.messaging.jmq.jmsspi.JMSAdmin;
import com.sun.messaging.jmq.jmsspi.JMSAdminFactory;
import com.sun.messaging.jmq.jmsspi.PropertiesHolder;
import java.util.Properties;
import javax.jms.JMSException;

public class JMSAdminFactoryImpl
implements JMSAdminFactory {
    private static AdminResources ar = Globals.getAdminResources();
    public static final String DEFAULT_ADMIN_USERNAME = "admin";
    public static final String DEFAULT_ADMIN_PASSWD = "admin";

    @Override
    public JMSAdmin getJMSAdmin() throws JMSException {
        return this.getJMSAdmin(false);
    }

    @Override
    public JMSAdmin getJMSAdmin(boolean secure) throws JMSException {
        Properties connectionProps = this.createProviderProperties(null, secure);
        return new JMSAdminImpl(connectionProps, null, "admin", "admin");
    }

    @Override
    public JMSAdmin getJMSAdmin(String jmsAdminURL, PropertiesHolder brokerPropertiesHolder, String adminUserName, String adminPassword) throws JMSException {
        return this.getJMSAdmin(jmsAdminURL, brokerPropertiesHolder, adminUserName, adminPassword, false);
    }

    @Override
    public JMSAdmin getJMSAdmin(String jmsAdminURL, String adminUserName, String adminPassword) throws JMSException {
        return this.getJMSAdmin(jmsAdminURL, null, adminUserName, adminPassword, false);
    }

    @Override
    public JMSAdmin getJMSAdmin(String jmsAdminURL, PropertiesHolder brokerPropertiesHolder, String userName, String adminPassword, boolean secure) throws JMSException {
        Properties connectionProps = this.createProviderProperties(jmsAdminURL, secure);
        JMSAdminImpl admin = new JMSAdminImpl(connectionProps, brokerPropertiesHolder, userName, adminPassword);
        return admin;
    }

    @Override
    public JMSAdmin getJMSAdmin(String jmsAdminURL, String adminUserName, String adminPassword, boolean secure) throws JMSException {
        Properties connectionProps = this.createProviderProperties(jmsAdminURL, secure);
        JMSAdminImpl admin = new JMSAdminImpl(connectionProps, null, adminUserName, adminPassword);
        return admin;
    }

    @Override
    public JMSAdmin getJMSAdmin(String jmsAdminURL) throws JMSException {
        return this.getJMSAdmin(jmsAdminURL, false);
    }

    @Override
    public JMSAdmin getJMSAdmin(String jmsAdminURL, boolean secure) throws JMSException {
        Properties connectionProps = this.createProviderProperties(jmsAdminURL, secure);
        JMSAdminImpl admin = new JMSAdminImpl(connectionProps, null, "admin", "admin");
        return admin;
    }

    private Properties createProviderProperties(String jmsAdminURL, boolean secure) throws JMSException {
        Properties tmpProps = new Properties();
        String host = this.getBrokerHost(jmsAdminURL);
        int port = this.getBrokerPort(jmsAdminURL);
        if (host != null) {
            tmpProps.setProperty("imqBrokerHostName", host);
        }
        if (port > 0) {
            tmpProps.setProperty("imqBrokerHostPort", String.valueOf(port));
        }
        if (secure) {
            tmpProps.setProperty("imqConnectionType", "TLS");
        }
        return tmpProps;
    }

    private String getBrokerHost(String brokerHostPort) {
        String host = brokerHostPort;
        if (brokerHostPort == null) {
            return null;
        }
        int i = brokerHostPort.indexOf(58);
        if (i >= 0) {
            host = brokerHostPort.substring(0, i);
        }
        if (host.equals("")) {
            return null;
        }
        return host;
    }

    private int getBrokerPort(String brokerHostPort) throws JMSException {
        int port = -1;
        if (brokerHostPort == null) {
            return port;
        }
        int i = brokerHostPort.indexOf(58);
        if (i >= 0) {
            try {
                port = Integer.parseInt(brokerHostPort.substring(i + 1));
            }
            catch (Exception e) {
                throw new JMSException(ar.getKString("A4014", brokerHostPort));
            }
        }
        return port;
    }
}

